import asyncio
import logging
import os
from src.config import Config
from src.api_utils import APIClient
from src.graph_builder import GraphBuilder
from src.utils import load_unlearning_entities

all_entities = load_unlearning_entities()

logging.basicConfig(level=logging.INFO)

async def main():
    cfg = Config()
    api_client = APIClient(cfg)
    graph_builder = GraphBuilder(cfg, api_client)

    for initial_entity in all_entities[:5]:

        logging.info(f"Building knowledge graph for entity: {initial_entity}")
        graph = await graph_builder.build(initial_entity)
        graph_builder.save(initial_entity, graph)
        logging.info(f"Graph construction finished.")

if __name__ == "__main__":
    asyncio.run(main())
